/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.traverse;

import net.minecraft.world.biome.Biome;
import rtg.api.world.RTGWorld;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.traverse.RealisticBiomeTRAVBase;

public class RealisticBiomeTRAVCliffs
extends RealisticBiomeTRAVBase {
    public RealisticBiomeTRAVCliffs(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().ALLOW_RIVERS.set(false);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPOvergrownCliffs(300.0f, 100.0f, 0.0f);
    }

    public static class TerrainBOPOvergrownCliffs
    extends TerrainBase {
        private float width;
        private float strength;
        private float lakeDepth;
        private float lakeWidth;
        private float terrainHeight;

        public TerrainBOPOvergrownCliffs(float mountainWidth, float mountainStrength, float depthLake) {
            this(mountainWidth, mountainStrength, depthLake, 260.0f, 68.0f);
        }

        public TerrainBOPOvergrownCliffs(float mountainWidth, float mountainStrength, float depthLake, float widthLake, float height) {
            this.width = mountainWidth;
            this.strength = mountainStrength;
            this.lakeDepth = depthLake;
            this.lakeWidth = widthLake;
            this.terrainHeight = height;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPOvergrownCliffs.terrainLonelyMountain(x, y, rtgWorld, river, this.strength, this.width, this.terrainHeight);
        }
    }
}

